/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.client.gui.core;

import hunternif.mc.impl.atlas.client.gui.core.GuiComponentButton;
import hunternif.mc.impl.atlas.client.gui.core.GuiToggleButton;
import hunternif.mc.impl.atlas.client.gui.core.IButtonListener;
import hunternif.mc.impl.atlas.client.gui.core.ISelectListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ToggleGroup<B extends GuiToggleButton>
implements Iterable<B> {
    private final List<B> buttons = new ArrayList<B>();
    private final List<ISelectListener<? extends B>> listeners = new ArrayList<ISelectListener<? extends B>>();
    private B selectedButton = null;
    private final ClickListener clickListener = new ClickListener();

    public boolean addButton(B button) {
        if (!this.buttons.contains(button)) {
            this.buttons.add(button);
            ((GuiComponentButton)((Object)button)).addListener(this.clickListener);
            ((GuiToggleButton)((Object)button)).setRadioGroup(this);
            return true;
        }
        return false;
    }

    public boolean removeButton(B button) {
        if (this.buttons.remove(button)) {
            ((GuiComponentButton)((Object)button)).removeListener(this.clickListener);
            ((GuiToggleButton)((Object)button)).setRadioGroup(null);
            return true;
        }
        return false;
    }

    public void removeAllButtons() {
        Iterator<B> iter = this.buttons.iterator();
        while (iter.hasNext()) {
            GuiToggleButton button = (GuiToggleButton)((Object)iter.next());
            button.removeListener(this.clickListener);
            button.setRadioGroup(null);
            iter.remove();
        }
    }

    public B getSelectedButton() {
        return this.selectedButton;
    }

    public void setSelectedButton(B button) {
        if (this.buttons.contains(button)) {
            if (this.selectedButton != null) {
                ((GuiToggleButton)((Object)this.selectedButton)).setSelected(false);
            }
            ((GuiToggleButton)((Object)button)).setSelected(true);
            this.selectedButton = button;
        }
    }

    @Override
    public Iterator<B> iterator() {
        return this.buttons.iterator();
    }

    public void addListener(ISelectListener<? extends B> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ISelectListener<? extends B> listener) {
        this.listeners.remove(listener);
    }

    private class ClickListener
    implements IButtonListener<B> {
        private ClickListener() {
        }

        @Override
        public void onClick(B button) {
            if (button != ToggleGroup.this.selectedButton) {
                if (ToggleGroup.this.selectedButton != null) {
                    ((GuiToggleButton)((Object)ToggleGroup.this.selectedButton)).setSelected(false);
                }
                ToggleGroup.this.selectedButton = button;
                for (ISelectListener listener : ToggleGroup.this.listeners) {
                    listener.onSelect(ToggleGroup.this.selectedButton);
                }
            }
        }
    }
}

